<?php
/*
 * Plugin Name:		TraitWare Authentication
 * Plugin URI:		https://traitware.com/
 * Description:		TraitWare allows the option to replace username and password with a secure QR or push notification. Admins can leave the username and password fields along with a Secure TraitWare login option, or they can hide these fields to simply use the TraitWare Secured login page.
 * Version:		1.1.1
 * Author:		TraitWare
 * License:		GPL-2.0+
 * 
 * TraitWare Authentication is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * TraitWare Authentication is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with TraitWare Authentication. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 *
 * License URI:		https://www.gnu.org/licenses/gpl-2.0.html
 */
/* Absolute path to the WordPress directory. */
if (!defined('ABSPATH'))
	define('ABSPATH', dirname(__FILE__) . '/');
//Define target URL for API calls
if(!defined('TWURL')) {define('TWURL', 'https://api.traitware.com/');}
require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
//Randomly generated CSRF token
$state = hash('sha256', mt_rand());
class traitware_authentication{
/* initializes plugin */
	
	public function __construct(){
	/* only use filter and action hooks in constructor to keep initialization fast */
	
		//redirect to our own login page instead of default
		add_action('login_form_login', array($this, 'redirect_to_traitware'));
		//redirect to homepage after logout
		add_action( 'wp_logout', array( $this, 'redirect_after_logout' ) );
		//Add option to log in with TraitWare on wp-login.php
		add_action('login_form', array($this, 'login_with_traitware'));
		//Add TraitWare integration button to profile.php
		add_action('show_user_profile', array($this, 'integrate_tw'));
		//Create TraitWare user when new user is created
		add_action('admin_footer_text', array($this, 'edit_new_user_form'));
		add_action('user_register', array($this, 'create_traitware_user'), 10, 1);
		//Check that first and last name fields have been entered when creating a user
		//add_filter('user_profile_update_errors', 'check_first_and_last_name', 10, 3);
		//Authenticate user when they visit return URI
		add_action('wp', array($this, 'tw_auth'));
		//Display plugin settings link on plugins menu
		add_filter('plugin_action_links_' . plugin_basename(__FILE__), array($this, 'traitware_settings_link'));
		//Add the plugin settings page
		//add_action('admin_menu', array($this, 'traitware_settings'));
		//Display the plugin options page for admins
		add_action('admin_menu', array($this, 'create_settings_page'));
		//add the admin settings
		add_action('admin_init', array($this, 'plugin_admin_init'));
		
		//create handler for failed login
		add_shortcode('login-failed-form', array($this, 'render_failed_login_form'));
		
		//Create handler for tw-auth
		add_shortcode('tw-auth', array($this, 'render_twAuth_form'));
	}
	public static function plugin_activated(){
	/* plugin activation hook
	 * creates all desired pages and configures database */
		
		global $wpdb;
		//configure sql_mode variable
		$wpdb->query('SET sql_mode=REPLACE(@@sql_mode, "NO_ZERO_IN_DATE", "");');
		$wpdb->query('SET sql_mode=REPLACE(@@sql_mode, "NO_ZERO_DATE", "");');
		
	
		//Check if column exists
		$result = $wpdb->get_col_length($wpdb->users, 'traitware_id');
		if ($result == NULL){
			//create column if it doesn't exist
			$wpdb->query("ALTER TABLE {$wpdb->users} ADD COLUMN traitware_id CHAR(36)");
		}
		//array that stores information about pages
		$page_definitions = array(
			'failed-login' => array(
				'title' => __('TraitWare Authentication has Failed', 'traitware-auth'),
				'content' => '[login-failed-form]'
			),
			
			'tw-auth' => array(
				'title'     => __('authenticating', 'traitware-auth'),
				'content'   => ''
			),
		);
		
		
		foreach ($page_definitions as $slug => $page){
		//go through page_definitions array, adding each page
			//$query=get_page_by_title($page[‘title’], ‘OBJECT’,‘page’);
			$query = new WP_Query(array('pagename=' . $slug));
			if (! $query->have_posts()){
			//check that the page doesn't exist already
			
				wp_insert_post(
				//insert the page using data from page_definitions
					array(
						'post_content'   => $page['content'],
						'post_name'      => $slug,
						'post_title'     => $page['title'],
						'post_status'    => 'publish',
						'post_type'      => 'page',
						'ping_status'    => 'closed',
						'comment_status' => 'closed',
					)
				);	
			}
		}
	}
	
	public function render_failed_login_form($attributes, $content = null){
	/* shortcode for rendering login form
	 * return shortcode output as a string */
	 
		//render the login form using an external template
		return $this->get_template_html('failed_login_form', $attributes);
	}
	
	public function render_twAuth_form($attributes){
	/* shortcode for rendering login form
	 * return shortcode output as a string */
		return $this->get_template_html('tw-auth', $attributes);
	}
	
	public function tw_auth(){
	/* Function occurs when user visits tw-auth page
	 * Makes initial rest call using GET parameters
	 * checks response for verification
	 * If token is recieved, authenticate user */
		
		if (is_page('tw-auth')){
		//Only execute if user is on tw-auth page
			/* Recieve redirect uri from TraitWare server and verify parameters */
			GLOBAL $wpdb;
			$options = get_option('traitware_options');
			if($_SERVER['REQUEST_METHOD'] == 'GET'){
			
				//retrieve and sanitize GET parameters
				$auth_code 	= $_GET['code'];
				$state		= $_GET['state'];
				$tw_user_id	= $_GET['traitwareUserId'];
			}
		
			/* make json request */
			
			//create json
			$data = new stdClass;
	
			$data->client_id = $options['APP_client_id'];
			$data->client_secret = $options['APP_client_secret'];
			$data->code = "{$auth_code}";
			$data->grant_type = "token";
			$json = json_encode($data);
			//create session
			$url = TWURL . 'customer-api/v1/oauth2/token';
			$curl = curl_init($url);
	
			//set header and content options
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-type: application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, $json);
			curl_setopt($curl, CURLOPT_HEADER, false);
	
			//recieve JSON response
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$json_response = curl_exec($curl);
			$json_response = json_decode($json_response);
			//close session
			curl_close($curl);
	
			if (isset($json_response->access_token) && $json_response->state == $state){
		
				/* find user associated with TWID */
		
				
				//Make query for user associated with TWID
				$wpdb->prepare("SELECT ID FROM $wpdb->users WHERE traitware_id = %s", $tw_user_id);
				$user_id = $wpdb->get_row( "SELECT * FROM $wpdb->users WHERE traitware_id = '{$tw_user_id}'", ARRAY_A );
				if (is_user_logged_in()){
				//integrate TraitWare
	
					//add TWID to database
					$current_user_id = get_current_user_id();
					$wpdb->query($wpdb->prepare("UPDATE $wpdb->users SET traitware_id = %s WHERE ID = %d", $tw_user_id, $current_user_id));
					//redirect user
					wp_redirect(admin_url('profile.php'));
					exit;
				}
				//check if user has a TraitWare ID
				if ($user_id['ID'] > 0){
				//authenticate user and redirect
					wp_set_current_user($user_id['ID']);
					wp_set_auth_cookie($user_id['ID'], true);
					wp_redirect(admin_url());
					exit;
				}
				
			}
			
			//At this point Authentication has failed
			wp_redirect(home_url('index.php/failed-login'));
			exit;
		}
	}
	
	public function redirect_to_traitware(){
	/* redirect user to TraitWare QR login page instead of default page */
	
		global $state;
		$options = get_option('traitware_options');
		//make sure redirect is only done on GET requests and if TraitWare login is required
		if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($options['tw_login_required'])){
			
			//check if user is already logged in
		        if (is_user_logged_in()){
				wp_redirect(admin_url());
				exit;
			}
			//create url
			$login_url = TWURL . "customer-api/v1/oauth2/authorization?client_id=" . $options['APP_client_id'] . "&response_type=code&state=" . $state;
			wp_redirect($login_url);
			exit;
		}
	}
	
	public function redirect_after_logout() {
		$redirect_url = home_url(  );
		wp_redirect( $redirect_url );
		exit;
	}
	
	public function login_with_traitware(){
	//Add link on wp-login.php to TraitWare login
	
		global $state;
		$options = get_option('traitware_options');
		?>
		<label for "user_pass">
			<a href="<?php echo TWURL . "customer-api/v1/oauth2/authorization?client_id=" . $options['APP_client_id'] . "&response_type=code&state=" . $state;?>">Login with TraitWare</a>
		<br>
		<br>
		</label>

		<?php
	}
	public function integrate_tw(){
	/* Add integrate button to account settings page */
		//Forge URL
		GLOBAL $state;
		$options = get_option('traitware_options');
		$login_url = TWURL . "customer-api/v1/oauth2/authorization?client_id=" . $options['APP_client_id'] . "&response_type=code&state=" . $state;
		
		//Add link to user settings page
		?>
		<tr class="user-pass1-wrap">
			<th><a href="<?php echo $login_url ?>"><?php _e('Integrate TraitWare'); ?></a></th>
		</tr>
		<?php
	}
	public function edit_new_user_form(){
    global $pagenow;

    # do this only in page user-new.php
    if($pagenow !== 'user-new.php')
        return;

    # do this only if you can
    if(!current_user_can('manage_options'))
        return false;
if(is_multisite()){
	/* Add a field for mobile phone when creating new users, to use for TraitWare user creation*/
	/* Added additional field creation for first name and last name in a multisite environment */
		?>
			<table class="form-table" id="mobile_phone">
			<tbody>
				<tr class="form-field form-required">
					<th scope="row">
						<label>
							Mobile Phone
							<span class="description">(required)</span>
						</label>
					</th>
					<td>
						<input id="mobilePhone" name="mobilePhone" value="" type="number">
					</td>
				<tr>
			</tbody>
		</table>
		<table class="form-table" id="first_name">
			<tbody>
				<tr class="form-field form-required">
					<th scope="row">
						<label>
							First Name
							<span class="description">(required)</span>
						</label>
					</th>
					<td>
						<input id="first_name" name="first_name" value="" type="text">
					</td>
				<tr>
			</tbody>
		</table>
		<table class="form-table" id="last_name">
			<tbody>
				<tr class="form-field form-required">
					<th scope="row">
						<label>
							Last Name
							<span class="description">(required)</span>
						</label>
					</th>
					<td>
						<input id="last_name" name="last_name" value="" type="text">
					</td>
				<tr>
			</tbody>
		</table>
		<?php } 
else if(!is_multisite()){
?>
			<table class="form-table" id="mobile_phone">
			<tbody>
				<tr class="form-field form-required">
					<th scope="row">
						<label>
							Mobile Phone
							<span class="description">(required)</span>
						</label>
					</th>
					<td>
						<input id="mobilePhone" name="mobilePhone" value="" type="number">
					</td>
				<tr>
			</tbody>
		</table>
<?php } ?>
<script>
		
		jQuery(function($){
	
			//Move custom fields below email field
			$('#last_name tr').insertAfter($('#email').parentsUntil('tr').parent());
			$('#first_name tr').insertAfter($('#email').parentsUntil('tr').parent());
			$('#mobile_phone tr').insertAfter($('#email').parentsUntil('tr').parent());
			
			//Edit first and last name fields to be required
			label = $('label[for=last_name]');
			label.html(label.html() + ' <span class="description">(required)</span>');
			$('#last_name').attr('required',true);
			label = $('label[for=first_name]');
			label.html(label.html() + ' <span class="description">(required)</span>');
			$('#first_name').attr('required',true);
		});
		//Make first and last names required
		document.getElementsByClassName("form-field")[2].className = "form-field form-required";
		document.getElementsByClassName("form-field")[3].className = "form-field form-required";
		</script>

		<?php
		}
	public function create_traitware_user(){
	/* Automate TraitWare integration when a new wordpress user is created
	 * Send post values to TraitWare API's to either a new user or get the TraitWare ID of the existing one. 
	 * Add TraitWare ID to the database
	 */
	
		if ($_POST['action'] === "createuser"){
			
			global $wpdb;
			$options = get_option('traitware_options');
			/* Make REST call for existing TraitWare user*/
			
			//create session
			$url = TWURL . "customer-api/v1/users/emailAddress/" . $_POST['email'];
			$curl = curl_init($url);
			//set header and content options
			curl_setopt($curl, CURLOPT_HTTPHEADER, array(
				'Content-type: application/json',
				'client_id: ' . $options['TCC_client_id'],
				'client_secret: ' . $options['TCC_client_secret']));
			curl_setopt($curl, CURLOPT_HEADER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);	
	
			//recieve JSON response
			$json_response = curl_exec($curl);
			$json_response = json_decode($json_response);
			//close session
			curl_close($curl);
			if (isset($json_response->traitwareUserId)){
				$tw_user_id = $json_response->traitwareUserId;
			}
			if (!isset($json_response->traitwareUserId)){
			/* Make second REST call if TraitWare user doesn't exist */
				$data = array(
					'firstName'	=> $_POST['first_name'],
					'lastName' 	=> $_POST['last_name'],
					'emailAddress' 	=> $_POST['email'],
					'mobilePhone'	=> $_POST['mobilePhone'],
					'active'	=> 'true',
					'applications'	=> array(array("client_id" => $options['APP_client_id']))
				);
		
				$json = json_encode($data);
				//create session
				$url = TWURL . "customer-api/v1/users";
				$curl = curl_init($url);
	
				//set header and content options
				curl_setopt($curl, CURLOPT_POST, true);
				curl_setopt($curl, CURLOPT_HTTPHEADER, array(
					'Content-type: application/json', 
					'client_id: ' . $options['TCC_client_id'],
					'client_secret: '. $options['TCC_client_secret']
				));
				curl_setopt($curl, CURLOPT_POSTFIELDS, $json);
				curl_setopt($curl, CURLOPT_HEADER, false);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);	
	
				//recieve JSON response
				$json_response = curl_exec($curl);
				$json_response = json_decode($json_response);
	
				//close session
				curl_close($curl);
	
				$tw_user_id = $json_response->traitwareUserId;
			}
			
			/* Add TraitWare ID to new user */
			//sanitize input
			$email = sanitize_text_field($_POST['email']);
			$wpdb->update($wpdb->users, array('traitware_id' => $tw_user_id), array('user_email' => $email));
		}
	}
	public function traitware_settings(){
		/* Create the links on the sidebar for the admin dashboard */
		add_menu_page('Top Level Menu', 'Top Level Menu', 'manage_options', 'traitware_authentication/traitware-settings.php', 'traitware_plugin_page', 'dashicons-tickets', 6 );
		add_submenu_page('traitware_authentication/traitware-settings.php', 'Sub level menu', 'Sub Level Menu', 'manage_options', 'traitware_authentication/traitware-sub-settings.php', 'traitware_sub_page');
	}
	public function create_settings_page(){
		/* Create the settings page itself and assign it a slug 'traitware-settings' */
		add_options_page('Settings', 'TraitWare Settings', 'manage_options', 'traitware-settings', array($this, 'traitware_settings_page'));
	}
	public function traitware_settings_link($links){
		/* Add the link to the plugins page */
		$mylinks = array('<a href="' . admin_url('options-general.php?page=traitware-settings') . '">Configure</a>');
		return array_merge($links, $mylinks);
	}
	
	public function traitware_settings_page(){
		//Initalize the settings page
		?>

		<div>
		<?php screen_icon();?>
		<form method="post" action="options.php">
		<?php settings_fields('traitware_options');?>
		<?php do_settings_sections('traitware-settings');?>
		<?php submit_button(); ?>
		</form></div>

		<?php
	}
	public function plugin_admin_init(){
		/* Add the plugin settings for admin users */
		//Create the option group; store all options in single array
		register_setting('traitware_options', 'traitware_options');
		//Add the section for the various fields
		add_settings_section('traitware_main', 'TraitWare Authentication Settings', array($this, 'settings_section_html'), 'traitware-settings');
		//Add the fields themselves
		add_settings_field('TCC_client_id', 'TCC Client ID (TraitWare Customer Console Client ID)', array($this, 'setting_input_field'), 'traitware-settings', 'traitware_main', array("TCC_client_id", "TCC Client ID", true));
		add_settings_field('TCC_client_secret', 'TCC Client Secret (TraitWare Customer Console Client Secret)', array($this, 'setting_input_field'), 'traitware-settings', 'traitware_main', array("TCC_client_secret", "TCC Client Secret", false));
		add_settings_field('APP_client_id', 'APP Client ID (TraitWare Application Client ID)', array($this, 'setting_input_field'), 'traitware-settings', 'traitware_main', array("APP_client_id", "APP Client ID", true));
		add_settings_field('APP_client_secret', 'APP Client Secret (TraitWare Application Client Secret)', array($this, 'setting_input_field'), 'traitware-settings', 'traitware_main', array("APP_client_secret", "APP Client Secret", false));
		//Add field for login screen
		add_settings_field('tw_login_required', 'Check the box to enable TraitWare Only Login (no username/password fields)', array($this, 'required_login_field'), 'traitware-settings', 'traitware_main');
	}
	public function settings_section_html(){} //Required function for settings API
	public function setting_input_field(array $args){
		/*echo a string for an input field for the settings API*/
		
		//Display options for convenience
		$options = get_option('traitware_options');
		
		//Show fields according to their type 
		if ($args[2]){
			echo "<input id='{$args[0]}' name='traitware_options[" . $args[0] . "]' size='40' type='text' value='{$options[$args[0]]}' />"; 
		}
		//Hide output if it is a secret
		else{
			echo "<input id='{$args[0]}' name='traitware_options[" . $args[0] . "]' size='40' type='password' value='{$options[$args[0]]}' />";
		}
	}
	
	public function required_login_field(){
		/* Option to let admins choose to make TraitWare login required or not */
		
		//Maintain checkbox status from last time it was changed
		$options = get_option('traitware_options');
		if (isset($options['tw_login_required'] )){
			echo "<input id='tw_login_required' name='traitware_options[tw_login_required]' size='40' type='checkbox' checked/>";
		}
		else {		
			echo "<input id='tw_login_required' name='traitware_options[tw_login_required]' size='40' type='checkbox' />";
		}
	}	
	private function get_template_html($template_name){
	/* renders the html of the template arg to a string and returns it
	 * $template_name - name of template(without extension) */
		
		//get html content from template and store into $html
		ob_start();
		do_action('login_before_' . $template_name);
		require('templates/' . $template_name . '.php');
		do_action('login_after_' . $template_name);
		$html = ob_get_contents();
		ob_end_clean();
		
		return $html;
	}
}
 
//initialize plugin
$traitware_authentication_pages = new traitware_authentication();
 
//create pages when plugin is activated
register_activation_hook(__FILE__, array('traitware_authentication', 'plugin_activated'));
?>